#version 130
#extension GL_EXT_gpu_shader4 : enable
// japanese traditional textile pt1Mod01.fsh  by  yasuo
  
//https://www.shadertoy.com/view/WtdXzM
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// All the distance functions from:https://iquilezles.org/articles/distfunctions2d
#define Rot(a) mat2(cos(a),-sin(a),sin(a),cos(a))
#define antialiasing(n) n/min(iResolution.y,iResolution.x)
#define S(d,b) 1.0-smoothstep(b,antialiasing(1.0),d)

float ndot(vec2 a, vec2 b ) { return a.x*b.x - a.y*b.y; }

float dBox2d(vec2 p, vec2 b) {
    return max(abs(p.x) - b.x, abs(p.y) - b.y);
}

float sdBox( in vec2 p, in vec2 b )
{
    vec2 d = abs(p)-b;
    return length(max(d,vec2(0))) + min(max(d.x,d.y),0.0);
}

float sdPie( in vec2 p, in vec2 c, in float r )
{
    p.x = abs(p.x);
    float l = length(p) - r;
    float m = length(p-c*clamp(dot(p,c),0.0,r)); // c = sin/cos of the aperture
    return max(l,m*sign(c.y*p.x-c.x*p.y));
}

float sdVesica(vec2 p, float r, float d)
{
    p = abs(p);
    float b = sqrt(r*r-d*d);
    return ((p.y-b)*d>p.x*b) ? length(p-vec2(0.0,b))
                             : length(p-vec2(-d,0.0))-r;
}

float sdRhombus( in vec2 p, in vec2 b ) 
{
    vec2 q = abs(p);
    float h = clamp((-2.0*ndot(q,b)+ndot(b,b))/dot(b,b),-1.0,1.0);
    float d = length( q - 0.5*b*vec2(1.0-h,1.0+h) );
    return d * sign( q.x*b.y + q.y*b.x - b.x*b.y );
}

float sdEllipse( in vec2 p, in vec2 ab )
{
    p = abs(p); if( p.x > p.y ) {p=p.yx;ab=ab.yx;}
    float l = ab.y*ab.y - ab.x*ab.x;
    float m = ab.x*p.x/l;      float m2 = m*m; 
    float n = ab.y*p.y/l;      float n2 = n*n; 
    float c = (m2+n2-1.0)/3.0; float c3 = c*c*c;
    float q = c3 + m2*n2*2.0;
    float d = c3 + m2*n2;
    float g = m + m*n2;
    float co;
    if( d<0.0 )
    {
        float h = acos(q/c3)/3.0;
        float s = cos(h);
        float t = sin(h)*sqrt(3.0);
        float rx = sqrt( -c*(s + t + 2.0) + m2 );
        float ry = sqrt( -c*(s - t + 2.0) + m2 );
        co = (ry+sign(l)*rx+abs(g)/(rx*ry)- m)/2.0;
    }
    else
    {
        float h = 2.0*m*n*sqrt( d );
        float s = sign(q+h)*pow(abs(q+h), 1.0/3.0);
        float u = sign(q-h)*pow(abs(q-h), 1.0/3.0);
        float rx = -s - u - c*4.0 + 2.0*m2;
        float ry = (s - u)*sqrt(3.0);
        float rm = sqrt( rx*rx + ry*ry );
        co = (ry/sqrt(rm-rx)+2.0*g/rm-m)/2.0;
    }
    vec2 r = ab * vec2(co, sqrt(1.0-co*co));
    return length(r-p) * sign(p.y-r.y);
}

float sdLine( in vec2 p, in vec2 a, in vec2 b )
{
    vec2 pa = p-a, ba = b-a;
    float h = clamp( dot(pa,ba)/dot(ba,ba), 0.0, 1.0 );
    return length( pa - ba*h );
}

vec3 textile1(vec2 p, vec3 col, vec3 rhcol) {
    vec2 size = vec2(0.04,0.1);
    float rh = sdRhombus(p,size);
    col = mix(col, rhcol,S(rh,-0.01));
    
    rh = sdRhombus((p+vec2(0.1,0.06))*Rot(radians(-65.0)),size);
    col = mix(col, rhcol,S(rh,-0.01));      
    
    rh = sdRhombus((p+vec2(-0.1,0.06))*Rot(radians(65.0)),size);
    col = mix(col, rhcol,S(rh,-0.01));   
    return col;
}

vec3 jpTraditionalTex1(vec2 p, vec3 col, vec3 rhcol) {
    vec2 pref = p;
    
    float scale = 1.5;
    p*=scale;
    p.x = mod(p.x,0.42)-0.21;
    p.y = mod(p.y,0.22)-0.11;

	p.y = abs(p.y);
    p.y -= 0.11;
    col = textile1(p,col,rhcol);
    
    p = pref;
    p*=scale;
    p.x -= 0.21;
    p.x = mod(p.x,0.42)-0.21;
    p.y = mod(p.y,0.44)-0.22;
    p.y = abs(p.y);
    p.y -= 0.11;
	float rh = sdRhombus(p,vec2(0.04,0.1));
    col = mix(col, rhcol,S(rh,-0.01));
    
    return col;
}

vec3 textile2(vec2 p, vec3 col, vec3 bcol){
float bsize = 0.15;
    p *= Rot(radians(45.0));
    float b = dBox2d(p,vec2(bsize));
    p = abs(p);
    p.x -= 0.067;
    p.y -= 0.067;
    float b2 = dBox2d(p,vec2(bsize/3.0));
    b = max(-b2,b);
    col = mix(col, bcol,S(b,-0.01));
    return col;
}

vec3 jpTraditionalTex2(vec2 p, vec3 col, vec3 bcol) {
    vec2 pref = p;

    float scale = 1.5;
    p*=scale;
    
    p = mod(p,0.45)-0.225;
    col = textile2(p,col,bcol);
    
    p = pref;
    p*=scale;
    p -= 0.225;
    p = mod(p,0.45)-0.225;
    col = textile2(p,col,bcol);
    
    return col;
}

vec3 jpTraditionalTex3(vec2 p, vec3 col, vec3 ccol) {
    vec2 pref = p;

    p.x = mod(p.x,0.25)-(0.25*0.5);
    p.y = mod(p.y,0.26)-(0.26*0.5);
    
    float r = 0.15;
    p = abs(p);
    p.x -= 0.06;
    p.y -= 0.065;
    
    float c = sdVesica(p*Rot(radians(-45.0)),r-0.02,r*0.63);
    col = mix(col, ccol,S(c,0.0));
    
    return col;
}

vec3 textile4(vec2 p, vec3 col, vec3 ccol){
    float r = 0.16;
    
    float c =sdPie(p,vec2(0.16,0.1),r);
    c = max(-(length(p)-0.05),c);
    col = mix(col, ccol,S(c,0.0)); 
    c =sdPie(p,vec2(0.16,0.1),r-0.02);
    c = max(-(length(p)-0.075),c);
    col = mix(col, vec3(1.0),S(c,0.0)); 
    c =sdPie(p,vec2(0.16,0.1),r-0.037);
    c = max(-(length(p)-0.095),c);
    col = mix(col, ccol,S(c,0.0)); 
    c = length(p-vec2(0.0,0.015))-0.02;
    col = mix(col, vec3(1.0),S(c,0.0)); 
    return col;
}

vec3 jpTraditionalTex4(vec2 p, vec3 col, vec3 ccol) {
    vec2 pref = p;

    p.x = mod(p.x,0.4)-(0.2);
    p.y = mod(p.y,0.18)-(0.09);
    p.y +=0.085;
    col = textile4(p,col,ccol);
    p= pref;
    
    p.x += 0.2;
    p.y -=0.085;
    p.x = mod(p.x,0.4)-(0.2);
    p.y = mod(p.y,0.18)-(0.09);
    p.y +=0.085;
    col = textile4(p,col,ccol);
    return col;
}

vec3 textile5(vec2 p, vec3 col, vec3 ccol){
    vec2 pref = p;
    p.y = abs(p.y);
    p.y -= 0.1;
    float c = sdEllipse(p,vec2(0.04,0.06));
    float c2 = sdEllipse((p-vec2(-0.02,-0.01))*Rot(radians(-10.0)),vec2(0.04,0.05));
    float c3 = sdEllipse((p-vec2(0.02,-0.01))*Rot(radians(10.0)),vec2(0.04,0.05));
    c = min(c, min(c2,c3));
    c = max(-(length(p-vec2(0.0,-0.05))-0.04),c);
	col = mix(col, ccol,S(c,0.0));
    p = pref;
    
    p.x = abs(p.x);
    p.x -= 0.13;
    c = sdEllipse(p,vec2(0.09,0.03));
    c2 = sdEllipse((p-vec2(-0.015,-0.015))*Rot(radians(15.0)),vec2(0.07,0.04));
    c3 = sdEllipse((p-vec2(-0.015,0.015))*Rot(radians(-15.0)),vec2(0.07,0.04));
    float c4 = sdEllipse(p-vec2(-0.05,0.0),vec2(0.07,0.025));
    c = min(c, min(c2,c3));
    c = max(-c4,c);
    col = mix(col, ccol,S(c,0.0));
    p = pref;
    
    col = mix(col, ccol,S(length(p)-0.03,0.0));
    
    p = abs(p);
    
    float b = dBox2d(p-vec2(0.0,0.23),vec2(0.05,0.045));
    float b2 = dBox2d(p-vec2(0.35,0.0),vec2(0.05,0.045));
    b = min(b,b2);
    col = mix(col, ccol,S(abs(b)-0.003,0.0));
    
    float l = sdLine(p,vec2(0.05,0.185),vec2(0.3,0.045));
    float l2 = sdLine(p,vec2(0.05,0.205),vec2(0.325,0.048));
    float l3 = sdLine(p,vec2(0.05,0.225),vec2(0.355,0.048));
    l = min(l,min(l2,l3));
    col = mix(col, ccol,S(l-0.002,0.0));
    return col;
}

vec3 jpTraditionalTex5(vec2 p, vec3 col, vec3 ccol) {
    vec2 pref = p;

    float scale = 1.5;
    p*=scale;
    
    p.x = mod(p.x,0.7)-0.35;
    p.y = mod(p.y,0.46)-0.23;
    col = textile5(p,col,ccol);
    p = pref;
    
    p*=scale;
    p.x -= 0.35;
    p.y -= 0.23;
    p.x = mod(p.x,0.7)-0.35;
    p.y = mod(p.y,0.46)-0.23;
    col = textile5(p,col,ccol);
    
    return col;
}

vec3 textile6(vec2 p, vec3 col, vec3 ccol){
	float n = 5.0;
    float deg = 360.0/n;
    float startRad = radians(180.0);
    for(float i = 0.0; i<n; i+=1.0) {
        float rad = radians(deg*i)+startRad;
        mat2 rot = Rot(rad);
        float dist = 0.15;
        float x = sin(rad)*dist;
        float y = cos(rad)*dist;

        float v = sdVesica((p+vec2(x,y))*rot,0.14,0.075);
		
        dist = 0.07;
        x = sin(rad)*dist;
        y = cos(rad)*dist;
        float e = sdEllipse((((p+vec2(x,y)))*rot),vec2(0.015,0.07));
        v = max(-e,v);
        col = mix(col, ccol,S(v,0.0));
    }
    
    float c = length(p)-0.03;
    col = mix(col, ccol,S(c,0.0));
    return col;
}

vec3 textile6RepeatBg(vec2 p, vec3 col, vec3 ccol){
    float scale = 1.5;
    p*=scale;
    p.x = mod(p.x,0.9)-0.45;
    p.y = mod(p.y,0.54)-0.275;
    col = textile6(p,col,ccol);
    return col;
}

vec3 jpTraditionalTex6(vec2 p, vec3 col, vec3 ccol) {
    vec2 pref = p;

    col = textile6RepeatBg(p,col,ccol);
    
    p.x -= 0.9;
    p.y -= 0.54;
    col = textile6RepeatBg(p,col,ccol);
    
    return col;
}

float leaf(vec2 p) {
	float c = length(p)-0.1;
    p.x *= 0.8;
    p.y *= 0.6;
    float c2  = length(p-vec2(0.06,0.05))-0.08;
    c = max(-c2,c);
    return c;
}

vec3 textile7(vec2 p, vec3 col, vec3 ccol){
    float n = 5.0;
    float deg = 360.0/n;
    float startRad = radians(180.0);
    float ld = 1.0;
    for(float i = 0.0; i<n; i+=1.0) {
        float rad = radians(deg*i)+startRad;
        mat2 rot = Rot(rad);
        float dist = 0.11;
        float x = sin(rad)*dist;
        float y = cos(rad)*dist;

       	float l = leaf((p+vec2(x,y))*rot);
        ld = min(ld,l);
    }

    ld = max(-( length(p)-0.05),ld);
    col = mix(col, ccol,S(ld,0.0));
    float c = length(p)-0.02;
    ld = min(c,ld);
    col = mix(col, ccol,S(ld,0.0));
    return col;
}

vec3 jpTraditionalTex7(vec2 p, vec3 col, vec3 ccol) {
    vec2 pref = p;
   	float scale = 1.5;
    p*=scale;
    
    p.x = mod(p.x,0.8)-0.4;
    p.y = mod(p.y,0.5)-0.25;
    col = textile7(p, col, ccol);
    p = pref;
    
    p*=scale;
    p.x -= 0.4;
    p.y -= 0.25;
	p.x = mod(p.x,0.8)-0.4;
    p.y = mod(p.y,0.5)-0.25;
    col = textile7(p, col, ccol);
    return col;
}

vec3 textile8(vec2 p, vec3 col, vec3 ccol){
    float b = sdBox(p*Rot(radians(45.0)),vec2(0.05))-0.05;
    b = max(-(length(p)-0.03),b);
    col = mix(col, ccol,S(b,0.0));
    return col;
}

vec3 jpTraditionalTex8(vec2 p, vec3 col, vec3 ccol) {
    vec2 pref = p;
    p = mod(p,0.3)-0.15;
    col = textile8(p,col,ccol);
    p = pref;
    
    p -= 0.15;
    p = mod(p,0.3)-0.15;
    col = textile8(p,col,ccol);
    return col;
}

vec3 textile9(vec2 p, vec3 col, vec3 ccol){
    float b = dBox2d(p,vec2(0.1));
    p.x = abs(p.x);
    p.x-=0.04;
    float b2 = dBox2d(p,vec2(0.02,0.11));
    b = max(-b2,b);
    col = mix(col, ccol,S(b,0.0));
    return col;
}

vec3 textile9RepeatBg(vec2 p, vec3 col, vec3 ccol) {
	vec2 pref = p;
    p.x = mod(p.x,0.45)-0.225;
	p.y = mod(p.y,0.45)-0.225;
    col = textile9(p,col,ccol);
    p = pref;
    
    p.y -= 0.225;
    p.x = mod(p.x,0.45)-0.225;
    p.y = mod(p.y,0.45)-0.225;
    col = textile9(p*Rot(radians(90.0)),col,ccol);
    return col;
}

vec3 jpTraditionalTex9(vec2 p, vec3 col, vec3 ccol) {
    vec2 pref = p;
    col = textile9RepeatBg(p,col,ccol);
    p -= 0.225;
    col = textile9RepeatBg(p,col,ccol);
    return col;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (fragCoord-.5*iResolution.xy)/iResolution.y;
    vec3 col = vec3(0.8,0.9,1.0);
	vec3 baseCol = vec3(0.0,0.3,0.5);
    
    uv.y -= iTime*0.1;
    
    float ratio = 1.0;
    float ntextile = 9.0;
    float scene = mod(iTime,ratio*ntextile);
    if(scene<ratio) {
        col = jpTraditionalTex1(uv,col,baseCol);
    } else if(scene>=ratio && scene<ratio*2.0){
        col = jpTraditionalTex2(uv,col,baseCol);
    } else if(scene>=ratio*2.0 && scene<ratio*3.0){
        col = jpTraditionalTex3(uv,col,baseCol);
    } else if(scene>=ratio*3.0 && scene<ratio*4.0){
        col = jpTraditionalTex4(uv,col,baseCol);
    } else if(scene>=ratio*4.0 && scene<ratio*5.0){
        col = jpTraditionalTex5(uv,col,baseCol);
    } else if(scene>=ratio*5.0 && scene<ratio*6.0){
        col = jpTraditionalTex6(uv,col,baseCol);
    } else if(scene>=ratio*6.0 && scene<ratio*7.0){
        col = jpTraditionalTex7(uv,col,baseCol);
    } else if(scene>=ratio*7.0 && scene<ratio*8.0){
        col = jpTraditionalTex8(uv,col,baseCol);
    } else if(scene>=ratio*8.0 && scene<ratio*9.0){
        col = jpTraditionalTex9(uv,col,baseCol);
    }
    
    /*
    col = vec3(0.8,0.9,1.0);
    col = jpTraditionalTex6(uv,col,vec3(0.0,0.3,0.5));
	*/
        
    fragColor = vec4(col,1.0);
    return fragColor; 
}
///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}
// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.